<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Registration</title>

    
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css">

    
    <style>
        body {
            background: #f4f6f9;
        }

        .header {
            background: linear-gradient(90deg, #1e3c72, #2a5298);
            color: white;
            padding: 15px;
        }

        .card {
            border-radius: 12px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.1);
        }

        .btn-custom {
            background-color: #1e3c72;
            color: white;
        }

        .btn-custom:hover {
            background-color: #16305c;
        }

        .list-group-item {
            background-color: #f8f9fa;
        }

        h2, h3 {
            color: #1e3c72;
        }
    </style>
</head>
<body>

<div class="container-fluid">

  
    <div class="row header">
        <div class="col">
            <h3 class="mb-0 text-warning">🎓 Student Registration System</h3>

        </div>
    </div>

    <div class="row py-5">

        <div class="col-md-6 mb-4">
            <div class="card p-4">
                <h2 class="mb-4">Registration</h2>

                <form action="" method="post">

                    <div class="form-group">
                        <label>Name</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>

                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" class="form-control" name="email" required>
                    </div>

                    <div class="form-group">
                        <label>Phone</label>
                        <input type="tel" class="form-control" name="phone" required>
                    </div>

                    <div class="form-group">
                        <label>Address</label>
                        <textarea class="form-control" name="address" rows="3" required></textarea>
                    </div>

                    <div class="form-group">
                        <label>Gender</label>
                        <select class="form-control" name="gender" required>
                            <option value="">-- Select Gender --</option>
                            <option>Male</option>
                            <option>Female</option>
                            <option>Other</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>Department</label>
                        <input type="text" class="form-control" name="department" required>
                    </div>

                    <div class="form-check mb-3">
                        <input type="checkbox" class="form-check-input" name="parttime">
                        <label class="form-check-label">Part-time Student</label>
                    </div>

                    <div class="form-group">
                        <label>Joined Date</label>
                        <input type="date" class="form-control" name="joined_date" required>
                    </div>

                    <button type="submit" class="btn btn-custom btn-block">
                        Register Student
                    </button>

                </form>
            </div>
        </div>

       
        <div class="col-md-6">
            <div class="card p-4">
                <h3 class="mb-4">Registered Students</h3>

                <ul class="list-group">
                    <li class="list-group-item">
                        <strong>Bagaa</strong><br>
                        bagaa@example.com | 2023-01-15
                    </li>
                    <li class="list-group-item">
                        <strong>Sanjeef</strong><br>
                        jane@example.com | 2023-02-20
                    </li>
                    <li class="list-group-item">
                        <strong>Alex</strong><br>
                        alex@example.com | 2023-03-25
                    </li>
                </ul>
            </div>
        </div>

    </div>
</div>

</body>
</html>
